<?php
/* --------------------------------------------------------------
   VpeServiceProvider.php 2021-11-03
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Deprecated\Vpe;

use Doctrine\DBAL\Connection;
use Gambio\Admin\Modules\UserFriendlyErrorPage\App\Data\Reader\PageNotFoundErrorPageReader;
use Gambio\Admin\Modules\UserFriendlyErrorPage\App\Data\Reader\UnexpectedErrorErrorPageReader;
use Gambio\Admin\Modules\UserFriendlyErrorPage\App\Data\Writer\ErrorPageGenerator;
use Gambio\Admin\Modules\UserFriendlyErrorPage\App\Data\Writer\PageNotFoundErrorPageWriter;
use Gambio\Admin\Modules\UserFriendlyErrorPage\App\Data\Writer\UnexpectedErrorErrorPageWriter;
use Gambio\Admin\Modules\UserFriendlyErrorPage\Services\UserFriendlyErrorPageErrorHandlerService;
use Gambio\Admin\Modules\UserFriendlyErrorPage\Services\UserFriendlyErrorPageService;
use Gambio\Admin\Modules\Deprecated\Vpe\App\Actions\ProductOptionVpe;
use Gambio\Admin\Modules\Deprecated\Vpe\App\Actions\StoreProductOptionVpeData;
use Gambio\Admin\Modules\Deprecated\Vpe\App\Actions\VpeConfiguration;
use Gambio\Admin\Modules\Deprecated\Vpe\App\Data\VpeReader;
use Gambio\Admin\Modules\Deprecated\Vpe\App\Data\VpeRepository;
use Gambio\Admin\Modules\Deprecated\Vpe\App\Data\VpeWriter;
use Gambio\Core\Application\DependencyInjection\AbstractServiceProvider;
use Gambio\Core\Application\ValueObjects\Environment;
use Gambio\Core\Application\ValueObjects\Url;
use Gambio\Core\Configuration\Services\ConfigurationService;
use Gambio\Core\Logging\LoggerBuilder;

/**
 * Class VpeServiceProvider
 *
 * @package    Gambio\Admin\Modules\Deprecated\Vpe
 * @deprecated will be removed with the release of 4.7!
 */
class VpeServiceProvider extends AbstractServiceProvider
{
    /**
     * @inheritDoc
     */
    public function provides(): array
    {
        return [
            VpeConfiguration::class,
            ProductOptionVpe::class,
            StoreProductOptionVpeData::class,
        ];
    }
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->application->registerShared(VpeReader::class)->addArgument(Connection::class);
        
        $this->application->registerShared(VpeWriter::class)->addArgument(Connection::class);
        
        $this->application->registerShared(VpeRepository::class)
            ->addArgument(ConfigurationService::class)
            ->addArgument(VpeReader::class)
            ->addArgument(VpeWriter::class);
        
        $this->application->registerShared(VpeConfiguration::class)->addArgument(VpeRepository::class);
        
        $this->application->registerShared(ProductOptionVpe::class)->addArgument(VpeRepository::class);
        
        $this->application->registerShared(StoreProductOptionVpeData::class)->addArgument(VpeRepository::class);
    }
}